/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

public class Bits {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private byte[] bytes;
    private int bytePtr;
    private int bitPtr;

    public void init() {
        this.bytes = new byte[1024];
        this.bytePtr = 0;
        this.bitPtr = 0;
    }

    public void advance(int n) {
        this.bytePtr += n >> 3;
        this.bitPtr += n & 7;
        if (this.bitPtr > 7) {
            this.bitPtr -= 8;
            ++this.bytePtr;
        }
    }

    protected void setBuffer(byte[] newBuffer) {
        this.bytes = newBuffer;
    }

    public int peek() {
        return (this.bytes[this.bytePtr] & 0xFF) >> 7 - this.bitPtr & 1;
    }

    public void read_from(byte[] newbytes, int offset, int len) {
        int i = 0;
        while (i < len) {
            this.bytes[i] = newbytes[offset + i];
            ++i;
        }
        this.bytePtr = 0;
        this.bitPtr = 0;
    }

    public int unpack(int nbBits) {
        int d = 0;
        while (nbBits != 0) {
            d <<= 1;
            d |= (this.bytes[this.bytePtr] & 0xFF) >> 7 - this.bitPtr & 1;
            ++this.bitPtr;
            if (this.bitPtr == 8) {
                this.bitPtr = 0;
                ++this.bytePtr;
            }
            --nbBits;
        }
        return d;
    }

    public void pack(int data, int nbBits) {
        int d = data;
        while (this.bytePtr + (nbBits + this.bitPtr >> 3) >= this.bytes.length) {
            int size = this.bytes.length * 2;
            byte[] tmp = new byte[size];
            System.arraycopy(this.bytes, 0, tmp, 0, this.bytes.length);
            this.bytes = tmp;
        }
        while (nbBits > 0) {
            int bit = d >> nbBits - 1 & 1;
            int n = this.bytePtr++;
            this.bytes[n] = (byte)(this.bytes[n] | bit << 7 - this.bitPtr);
            ++this.bitPtr;
            if (this.bitPtr == 8) {
                this.bitPtr = 0;
            }
            --nbBits;
        }
    }

    public byte[] getBuffer() {
        return this.bytes;
    }

    public int getBufferSize() {
        return this.bytePtr + (this.bitPtr > 0 ? 1 : 0);
    }
}

