/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.Bits;
import org.xiph.speex.LspQuant;

public class LbrLspQuant
extends LspQuant {
    public final void quant(float[] lsp, float[] qlsp, int order, Bits bits) {
        float[] quant_weight = new float[20];
        int i = 0;
        while (i < order) {
            qlsp[i] = lsp[i];
            ++i;
        }
        quant_weight[0] = 1.0f / (qlsp[1] - qlsp[0]);
        quant_weight[order - 1] = 1.0f / (qlsp[order - 1] - qlsp[order - 2]);
        i = 1;
        while (i < order - 1) {
            float tmp1 = 1.0f / ((0.15f + qlsp[i] - qlsp[i - 1]) * (0.15f + qlsp[i] - qlsp[i - 1]));
            float tmp2 = 1.0f / ((0.15f + qlsp[i + 1] - qlsp[i]) * (0.15f + qlsp[i + 1] - qlsp[i]));
            quant_weight[i] = tmp1 > tmp2 ? tmp1 : tmp2;
            ++i;
        }
        i = 0;
        while (i < order) {
            int n = i;
            qlsp[n] = (float)((double)qlsp[n] - (0.25 * (double)i + 0.25));
            ++i;
        }
        i = 0;
        while (i < order) {
            int n = i++;
            qlsp[n] = qlsp[n] * 256.0f;
        }
        int id = LbrLspQuant.lsp_quant(qlsp, 0, cdbk_nb, 64, order);
        bits.pack(id, 6);
        i = 0;
        while (i < order) {
            int n = i++;
            qlsp[n] = qlsp[n] * 2.0f;
        }
        id = LbrLspQuant.lsp_weight_quant(qlsp, 0, quant_weight, 0, cdbk_nb_low1, 64, 5);
        bits.pack(id, 6);
        id = LbrLspQuant.lsp_weight_quant(qlsp, 5, quant_weight, 5, cdbk_nb_high1, 64, 5);
        bits.pack(id, 6);
        i = 0;
        while (i < order) {
            int n = i++;
            qlsp[n] = (float)((double)qlsp[n] * 0.0019531);
        }
        i = 0;
        while (i < order) {
            qlsp[i] = lsp[i] - qlsp[i];
            ++i;
        }
    }

    public final void unquant(float[] lsp, int order, Bits bits) {
        int i = 0;
        while (i < order) {
            lsp[i] = 0.25f * (float)i + 0.25f;
            ++i;
        }
        this.unpackPlus(lsp, cdbk_nb, bits, 0.0039062f, 10, 0);
        this.unpackPlus(lsp, cdbk_nb_low1, bits, 0.0019531f, 5, 0);
        this.unpackPlus(lsp, cdbk_nb_high1, bits, 0.0019531f, 5, 5);
    }
}

