/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.Bits;
import org.xiph.speex.Encoder;
import org.xiph.speex.Filters;
import org.xiph.speex.Lpc;
import org.xiph.speex.Lsp;
import org.xiph.speex.Misc;
import org.xiph.speex.NbEncoder;
import org.xiph.speex.SbCodec;
import org.xiph.speex.Vbr;

public class SbEncoder
extends SbCodec
implements Encoder {
    public static final int[] NB_QUALITY_MAP = new int[]{1, 8, 2, 3, 4, 5, 5, 6, 6, 7, 7};
    public static final int[] WB_QUALITY_MAP = new int[]{1, 1, 1, 1, 1, 1, 2, 2, 3, 3, 4};
    public static final int[] UWB_QUALITY_MAP;
    protected Encoder lowenc;
    private float[] x1d;
    private float[] h0_mem;
    private float[] buf;
    private float[] swBuf;
    private float[] res;
    private float[] target;
    private float[] window;
    private float[] lagWindow;
    private float[] rc;
    private float[] autocorr;
    private float[] lsp;
    private float[] old_lsp;
    private float[] interp_lsp;
    private float[] interp_lpc;
    private float[] bw_lpc1;
    private float[] bw_lpc2;
    private float[] mem_sp2;
    private float[] mem_sw;
    protected int nb_modes;
    private boolean uwb;
    protected int complexity;
    protected int vbr_enabled;
    protected int vad_enabled;
    protected int abr_enabled;
    protected float vbr_quality;
    protected float relative_quality;
    protected float abr_drift;
    protected float abr_drift2;
    protected float abr_count;
    protected int sampling_rate;
    protected int submodeSelect;

    static {
        int[] nArray = new int[11];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[10] = 1;
        UWB_QUALITY_MAP = nArray;
    }

    public void wbinit() {
        this.lowenc = new NbEncoder();
        ((NbEncoder)this.lowenc).nbinit();
        super.wbinit();
        this.init(160, 40, 8, 640, 0.9f);
        this.uwb = false;
        this.nb_modes = 5;
        this.sampling_rate = 16000;
    }

    public void uwbinit() {
        this.lowenc = new SbEncoder();
        ((SbEncoder)this.lowenc).wbinit();
        super.uwbinit();
        this.init(320, 80, 8, 1280, 0.7f);
        this.uwb = true;
        this.nb_modes = 2;
        this.sampling_rate = 32000;
    }

    public void init(int frameSize, int subframeSize, int lpcSize, int bufSize, float foldingGain) {
        super.init(frameSize, subframeSize, lpcSize, bufSize, foldingGain);
        this.complexity = 3;
        this.vbr_enabled = 0;
        this.vad_enabled = 0;
        this.abr_enabled = 0;
        this.vbr_quality = 8.0f;
        this.submodeSelect = this.submodeID;
        this.x1d = new float[frameSize];
        this.h0_mem = new float[64];
        this.buf = new float[this.windowSize];
        this.swBuf = new float[frameSize];
        this.res = new float[frameSize];
        this.target = new float[subframeSize];
        this.window = Misc.window(this.windowSize, subframeSize);
        this.lagWindow = Misc.lagWindow(lpcSize, this.lag_factor);
        this.rc = new float[lpcSize];
        this.autocorr = new float[lpcSize + 1];
        this.lsp = new float[lpcSize];
        this.old_lsp = new float[lpcSize];
        this.interp_lsp = new float[lpcSize];
        this.interp_lpc = new float[lpcSize + 1];
        this.bw_lpc1 = new float[lpcSize + 1];
        this.bw_lpc2 = new float[lpcSize + 1];
        this.mem_sp2 = new float[lpcSize];
        this.mem_sw = new float[lpcSize];
        this.abr_count = 0.0f;
    }

    public int encode(Bits bits, float[] in) {
        Filters.qmf_decomp(in, h0, this.x0d, this.x1d, this.fullFrameSize, 64, this.h0_mem);
        this.lowenc.encode(bits, this.x0d);
        int i = 0;
        while (i < this.windowSize - this.frameSize) {
            this.high[i] = this.high[this.frameSize + i];
            ++i;
        }
        i = 0;
        while (i < this.frameSize) {
            this.high[this.windowSize - this.frameSize + i] = this.x1d[i];
            ++i;
        }
        System.arraycopy(this.excBuf, this.frameSize, this.excBuf, 0, this.bufSize - this.frameSize);
        float[] low_pi_gain = this.lowenc.getPiGain();
        float[] low_exc = this.lowenc.getExc();
        float[] low_innov = this.lowenc.getInnov();
        int low_mode = this.lowenc.getMode();
        boolean dtx = low_mode == 0;
        i = 0;
        while (i < this.windowSize) {
            this.buf[i] = this.high[i] * this.window[i];
            ++i;
        }
        Lpc.autocorr(this.buf, this.autocorr, this.lpcSize + 1, this.windowSize);
        this.autocorr[0] = this.autocorr[0] + 1.0f;
        this.autocorr[0] = this.autocorr[0] * this.lpc_floor;
        i = 0;
        while (i < this.lpcSize + 1) {
            int n = i;
            this.autocorr[n] = this.autocorr[n] * this.lagWindow[i];
            ++i;
        }
        Lpc.wld(this.lpc, this.autocorr, this.rc, this.lpcSize);
        System.arraycopy(this.lpc, 0, this.lpc, 1, this.lpcSize);
        this.lpc[0] = 1.0f;
        int roots = Lsp.lpc2lsp(this.lpc, this.lpcSize, this.lsp, 15, 0.2f);
        if (roots != this.lpcSize && (roots = Lsp.lpc2lsp(this.lpc, this.lpcSize, this.lsp, 11, 0.02f)) != this.lpcSize) {
            i = 0;
            while (i < this.lpcSize) {
                this.lsp[i] = (float)Math.cos(Math.PI * (double)(i + 1) / (double)(this.lpcSize + 1));
                ++i;
            }
        }
        i = 0;
        while (i < this.lpcSize) {
            this.lsp[i] = (float)Math.acos(this.lsp[i]);
            ++i;
        }
        if (!(this.vbr_enabled == 0 && this.vad_enabled == 0 || dtx)) {
            int modeid;
            float e_low = 0.0f;
            float e_high = 0.0f;
            if (this.abr_enabled != 0) {
                float qual_change = 0.0f;
                if (this.abr_drift2 * this.abr_drift > 0.0f) {
                    qual_change = -1.0E-5f * this.abr_drift / (1.0f + this.abr_count);
                    if (qual_change > 0.1f) {
                        qual_change = 0.1f;
                    }
                    if (qual_change < -0.1f) {
                        qual_change = -0.1f;
                    }
                }
                this.vbr_quality += qual_change;
                if (this.vbr_quality > 10.0f) {
                    this.vbr_quality = 10.0f;
                }
                if (this.vbr_quality < 0.0f) {
                    this.vbr_quality = 0.0f;
                }
            }
            i = 0;
            while (i < this.frameSize) {
                e_low += this.x0d[i] * this.x0d[i];
                e_high += this.high[i] * this.high[i];
                ++i;
            }
            float ratio = (float)Math.log((1.0f + e_high) / (1.0f + e_low));
            this.relative_quality = this.lowenc.getRelativeQuality();
            if (ratio < -4.0f) {
                ratio = -4.0f;
            }
            if (ratio > 2.0f) {
                ratio = 2.0f;
            }
            if (this.vbr_enabled != 0) {
                modeid = this.nb_modes - 1;
                this.relative_quality = (float)((double)this.relative_quality + 1.0 * (double)(ratio + 2.0f));
                if (this.relative_quality < -1.0f) {
                    this.relative_quality = -1.0f;
                }
                while (modeid != 0) {
                    int v1 = (int)Math.floor(this.vbr_quality);
                    float thresh = v1 == 10 ? Vbr.hb_thresh[modeid][v1] : (this.vbr_quality - (float)v1) * Vbr.hb_thresh[modeid][v1 + 1] + ((float)(1 + v1) - this.vbr_quality) * Vbr.hb_thresh[modeid][v1];
                    if (this.relative_quality >= thresh) break;
                    --modeid;
                }
                this.setMode(modeid);
                if (this.abr_enabled != 0) {
                    int bitrate = this.getBitRate();
                    this.abr_drift += (float)(bitrate - this.abr_enabled);
                    this.abr_drift2 = 0.95f * this.abr_drift2 + 0.05f * (float)(bitrate - this.abr_enabled);
                    this.abr_count = (float)((double)this.abr_count + 1.0);
                }
            } else {
                modeid = (double)this.relative_quality < 2.0 ? 1 : this.submodeSelect;
                this.submodeID = modeid;
            }
        }
        bits.pack(1, 1);
        if (dtx) {
            bits.pack(0, 3);
        } else {
            bits.pack(this.submodeID, 3);
        }
        if (dtx || this.submodes[this.submodeID] == null) {
            i = 0;
            while (i < this.frameSize) {
                this.swBuf[i] = 0.0f;
                this.excBuf[this.excIdx + i] = 0.0f;
                ++i;
            }
            i = 0;
            while (i < this.lpcSize) {
                this.mem_sw[i] = 0.0f;
                ++i;
            }
            this.first = 1;
            Filters.iir_mem2(this.excBuf, this.excIdx, this.interp_qlpc, this.high, 0, this.subframeSize, this.lpcSize, this.mem_sp);
            this.filters.fir_mem_up(this.x0d, h0, this.y0, this.fullFrameSize, 64, this.g0_mem);
            this.filters.fir_mem_up(this.high, h1, this.y1, this.fullFrameSize, 64, this.g1_mem);
            i = 0;
            while (i < this.fullFrameSize) {
                in[i] = 2.0f * (this.y0[i] - this.y1[i]);
                ++i;
            }
            if (dtx) {
                return 0;
            }
            return 1;
        }
        this.submodes[this.submodeID].lsqQuant.quant(this.lsp, this.qlsp, this.lpcSize, bits);
        if (this.first != 0) {
            i = 0;
            while (i < this.lpcSize) {
                this.old_lsp[i] = this.lsp[i];
                ++i;
            }
            i = 0;
            while (i < this.lpcSize) {
                this.old_qlsp[i] = this.qlsp[i];
                ++i;
            }
        }
        float[] mem = new float[this.lpcSize];
        float[] syn_resp = new float[this.subframeSize];
        float[] innov = new float[this.subframeSize];
        int sub = 0;
        while (sub < this.nbSubframes) {
            int offset;
            float eh = 0.0f;
            float el = 0.0f;
            int sp = offset = this.subframeSize * sub;
            int exc = this.excIdx + offset;
            int resp = offset;
            int sw = offset;
            float tmp = (1.0f + (float)sub) / (float)this.nbSubframes;
            i = 0;
            while (i < this.lpcSize) {
                this.interp_lsp[i] = (1.0f - tmp) * this.old_lsp[i] + tmp * this.lsp[i];
                ++i;
            }
            i = 0;
            while (i < this.lpcSize) {
                this.interp_qlsp[i] = (1.0f - tmp) * this.old_qlsp[i] + tmp * this.qlsp[i];
                ++i;
            }
            Lsp.enforce_margin(this.interp_lsp, this.lpcSize, 0.05f);
            Lsp.enforce_margin(this.interp_qlsp, this.lpcSize, 0.05f);
            i = 0;
            while (i < this.lpcSize) {
                this.interp_lsp[i] = (float)Math.cos(this.interp_lsp[i]);
                ++i;
            }
            i = 0;
            while (i < this.lpcSize) {
                this.interp_qlsp[i] = (float)Math.cos(this.interp_qlsp[i]);
                ++i;
            }
            this.m_lsp.lsp2lpc(this.interp_lsp, this.interp_lpc, this.lpcSize);
            this.m_lsp.lsp2lpc(this.interp_qlsp, this.interp_qlpc, this.lpcSize);
            Filters.bw_lpc(this.gamma1, this.interp_lpc, this.bw_lpc1, this.lpcSize);
            Filters.bw_lpc(this.gamma2, this.interp_lpc, this.bw_lpc2, this.lpcSize);
            float rh = 0.0f;
            float rl = 0.0f;
            tmp = 1.0f;
            this.pi_gain[sub] = 0.0f;
            i = 0;
            while (i <= this.lpcSize) {
                rh += tmp * this.interp_qlpc[i];
                tmp = -tmp;
                int n = sub;
                this.pi_gain[n] = this.pi_gain[n] + this.interp_qlpc[i];
                ++i;
            }
            rl = low_pi_gain[sub];
            rl = 1.0f / (Math.abs(rl) + 0.01f);
            rh = 1.0f / (Math.abs(rh) + 0.01f);
            float filter_ratio = Math.abs(0.01f + rh) / (0.01f + Math.abs(rl));
            Filters.fir_mem2(this.high, sp, this.interp_qlpc, this.excBuf, exc, this.subframeSize, this.lpcSize, this.mem_sp2);
            i = 0;
            while (i < this.subframeSize) {
                eh += this.excBuf[exc + i] * this.excBuf[exc + i];
                ++i;
            }
            if (this.submodes[this.submodeID].innovation == null) {
                i = 0;
                while (i < this.subframeSize) {
                    el += low_innov[offset + i] * low_innov[offset + i];
                    ++i;
                }
                float g = eh / (0.01f + el);
                g = (float)Math.sqrt(g);
                int quant = (int)Math.floor(10.5 + 8.0 * Math.log((double)(g *= filter_ratio) + 1.0E-4));
                if (quant < 0) {
                    quant = 0;
                }
                if (quant > 31) {
                    quant = 31;
                }
                bits.pack(quant, 5);
                g = (float)(0.1 * Math.exp((double)quant / 9.4));
                g /= filter_ratio;
            } else {
                i = 0;
                while (i < this.subframeSize) {
                    el += low_exc[offset + i] * low_exc[offset + i];
                    ++i;
                }
                float gc = (float)(Math.sqrt(1.0f + eh) * (double)filter_ratio / Math.sqrt((1.0f + el) * (float)this.subframeSize));
                int qgc = (int)Math.floor(0.5 + 3.7 * (Math.log(gc) + 2.0));
                if (qgc < 0) {
                    qgc = 0;
                }
                if (qgc > 15) {
                    qgc = 15;
                }
                bits.pack(qgc, 4);
                gc = (float)Math.exp(0.27027027027027023 * (double)qgc - 2.0);
                float scale = gc * (float)Math.sqrt(1.0f + el) / filter_ratio;
                float scale_1 = 1.0f / scale;
                i = 0;
                while (i < this.subframeSize) {
                    this.excBuf[exc + i] = 0.0f;
                    ++i;
                }
                this.excBuf[exc] = 1.0f;
                Filters.syn_percep_zero(this.excBuf, exc, this.interp_qlpc, this.bw_lpc1, this.bw_lpc2, syn_resp, this.subframeSize, this.lpcSize);
                i = 0;
                while (i < this.subframeSize) {
                    this.excBuf[exc + i] = 0.0f;
                    ++i;
                }
                i = 0;
                while (i < this.lpcSize) {
                    mem[i] = this.mem_sp[i];
                    ++i;
                }
                Filters.iir_mem2(this.excBuf, exc, this.interp_qlpc, this.excBuf, exc, this.subframeSize, this.lpcSize, mem);
                i = 0;
                while (i < this.lpcSize) {
                    mem[i] = this.mem_sw[i];
                    ++i;
                }
                Filters.filter_mem2(this.excBuf, exc, this.bw_lpc1, this.bw_lpc2, this.res, resp, this.subframeSize, this.lpcSize, mem, 0);
                i = 0;
                while (i < this.lpcSize) {
                    mem[i] = this.mem_sw[i];
                    ++i;
                }
                Filters.filter_mem2(this.high, sp, this.bw_lpc1, this.bw_lpc2, this.swBuf, sw, this.subframeSize, this.lpcSize, mem, 0);
                i = 0;
                while (i < this.subframeSize) {
                    this.target[i] = this.swBuf[sw + i] - this.res[resp + i];
                    ++i;
                }
                i = 0;
                while (i < this.subframeSize) {
                    this.excBuf[exc + i] = 0.0f;
                    ++i;
                }
                i = 0;
                while (i < this.subframeSize) {
                    int n = i++;
                    this.target[n] = this.target[n] * scale_1;
                }
                i = 0;
                while (i < this.subframeSize) {
                    innov[i] = 0.0f;
                    ++i;
                }
                this.submodes[this.submodeID].innovation.quant(this.target, this.interp_qlpc, this.bw_lpc1, this.bw_lpc2, this.lpcSize, this.subframeSize, innov, 0, syn_resp, bits, this.complexity + 1 >> 1);
                i = 0;
                while (i < this.subframeSize) {
                    int n = exc + i;
                    this.excBuf[n] = this.excBuf[n] + innov[i] * scale;
                    ++i;
                }
                if (this.submodes[this.submodeID].double_codebook != 0) {
                    float[] innov2 = new float[this.subframeSize];
                    i = 0;
                    while (i < this.subframeSize) {
                        innov2[i] = 0.0f;
                        ++i;
                    }
                    i = 0;
                    while (i < this.subframeSize) {
                        int n = i++;
                        this.target[n] = (float)((double)this.target[n] * 2.5);
                    }
                    this.submodes[this.submodeID].innovation.quant(this.target, this.interp_qlpc, this.bw_lpc1, this.bw_lpc2, this.lpcSize, this.subframeSize, innov2, 0, syn_resp, bits, this.complexity + 1 >> 1);
                    i = 0;
                    while (i < this.subframeSize) {
                        int n = i++;
                        innov2[n] = (float)((double)innov2[n] * ((double)scale * 0.4));
                    }
                    i = 0;
                    while (i < this.subframeSize) {
                        int n = exc + i;
                        this.excBuf[n] = this.excBuf[n] + innov2[i];
                        ++i;
                    }
                }
            }
            i = 0;
            while (i < this.lpcSize) {
                mem[i] = this.mem_sp[i];
                ++i;
            }
            Filters.iir_mem2(this.excBuf, exc, this.interp_qlpc, this.high, sp, this.subframeSize, this.lpcSize, this.mem_sp);
            Filters.filter_mem2(this.high, sp, this.bw_lpc1, this.bw_lpc2, this.swBuf, sw, this.subframeSize, this.lpcSize, this.mem_sw, 0);
            ++sub;
        }
        this.filters.fir_mem_up(this.x0d, h0, this.y0, this.fullFrameSize, 64, this.g0_mem);
        this.filters.fir_mem_up(this.high, h1, this.y1, this.fullFrameSize, 64, this.g1_mem);
        i = 0;
        while (i < this.fullFrameSize) {
            in[i] = 2.0f * (this.y0[i] - this.y1[i]);
            ++i;
        }
        i = 0;
        while (i < this.lpcSize) {
            this.old_lsp[i] = this.lsp[i];
            ++i;
        }
        i = 0;
        while (i < this.lpcSize) {
            this.old_qlsp[i] = this.qlsp[i];
            ++i;
        }
        this.first = 0;
        return 1;
    }

    public int getEncodedFrameSize() {
        int size = SB_FRAME_SIZE[this.submodeID];
        return size += this.lowenc.getEncodedFrameSize();
    }

    public void setQuality(int quality) {
        if (quality < 0) {
            quality = 0;
        }
        if (quality > 10) {
            quality = 10;
        }
        if (this.uwb) {
            this.lowenc.setQuality(quality);
            this.setMode(UWB_QUALITY_MAP[quality]);
        } else {
            this.lowenc.setMode(NB_QUALITY_MAP[quality]);
            this.setMode(WB_QUALITY_MAP[quality]);
        }
    }

    public void setVbrQuality(float quality) {
        this.vbr_quality = quality;
        float qual = quality + 0.6f;
        if (qual > 10.0f) {
            qual = 10.0f;
        }
        this.lowenc.setVbrQuality(qual);
        int q = (int)Math.floor(0.5 + (double)quality);
        if (q > 10) {
            q = 10;
        }
        this.setQuality(q);
    }

    public void setVbr(boolean vbr) {
        this.vbr_enabled = vbr ? 1 : 0;
        this.lowenc.setVbr(vbr);
    }

    public void setAbr(int abr) {
        this.lowenc.setVbr(true);
        this.abr_enabled = abr != 0 ? 1 : 0;
        this.vbr_enabled = 1;
        int i = 10;
        int target = abr;
        while (i >= 0) {
            this.setQuality(i);
            int rate = this.getBitRate();
            if (rate <= target) break;
            --i;
        }
        float vbr_qual = i;
        if (vbr_qual < 0.0f) {
            vbr_qual = 0.0f;
        }
        this.setVbrQuality(vbr_qual);
        this.abr_count = 0.0f;
        this.abr_drift = 0.0f;
        this.abr_drift2 = 0.0f;
    }

    public int getBitRate() {
        if (this.submodes[this.submodeID] != null) {
            return this.lowenc.getBitRate() + this.sampling_rate * this.submodes[this.submodeID].bits_per_frame / this.frameSize;
        }
        return this.lowenc.getBitRate() + this.sampling_rate * 4 / this.frameSize;
    }

    public void setSamplingRate(int rate) {
        this.sampling_rate = rate;
        this.lowenc.setSamplingRate(rate);
    }

    public int getLookAhead() {
        return 2 * this.lowenc.getLookAhead() + 64 - 1;
    }

    public void setMode(int mode) {
        if (mode < 0) {
            mode = 0;
        }
        this.submodeID = this.submodeSelect = mode;
    }

    public int getMode() {
        return this.submodeID;
    }

    public void setBitRate(int bitrate) {
        int i = 10;
        while (i >= 0) {
            this.setQuality(i);
            if (this.getBitRate() <= bitrate) {
                return;
            }
            --i;
        }
    }

    public boolean getVbr() {
        return this.vbr_enabled != 0;
    }

    public void setVad(boolean vad) {
        this.vad_enabled = vad ? 1 : 0;
    }

    public boolean getVad() {
        return this.vad_enabled != 0;
    }

    public void setDtx(boolean dtx) {
        this.dtx_enabled = dtx ? 1 : 0;
    }

    public int getAbr() {
        return this.abr_enabled;
    }

    public float getVbrQuality() {
        return this.vbr_quality;
    }

    public void setComplexity(int complexity) {
        if (complexity < 0) {
            complexity = 0;
        }
        if (complexity > 10) {
            complexity = 10;
        }
        this.complexity = complexity;
    }

    public int getComplexity() {
        return this.complexity;
    }

    public int getSamplingRate() {
        return this.sampling_rate;
    }

    public float getRelativeQuality() {
        return this.relative_quality;
    }
}

