/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import java.io.StreamCorruptedException;
import org.xiph.speex.Bits;
import org.xiph.speex.Decoder;
import org.xiph.speex.NbDecoder;
import org.xiph.speex.SbDecoder;

public class SpeexDecoder {
    public static final String VERSION = "Java Speex Decoder v0.9.7 ($Revision: 1.4 $)";
    private int sampleRate = 0;
    private int channels = 0;
    private float[] decodedData;
    private short[] outputData;
    private int outputSize;
    private Bits bits = new Bits();
    private Decoder decoder;
    private int frameSize;

    public boolean init(int mode, int sampleRate, int channels, boolean enhanced) {
        switch (mode) {
            case 0: {
                this.decoder = new NbDecoder();
                ((NbDecoder)this.decoder).nbinit();
                break;
            }
            case 1: {
                this.decoder = new SbDecoder();
                ((SbDecoder)this.decoder).wbinit();
                break;
            }
            case 2: {
                this.decoder = new SbDecoder();
                ((SbDecoder)this.decoder).uwbinit();
                break;
            }
            default: {
                return false;
            }
        }
        this.decoder.setPerceptualEnhancement(enhanced);
        this.frameSize = this.decoder.getFrameSize();
        this.sampleRate = sampleRate;
        this.channels = channels;
        int secondSize = sampleRate * channels;
        this.decodedData = new float[secondSize * 2];
        this.outputData = new short[secondSize * 2];
        this.outputSize = 0;
        this.bits.init();
        return true;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getProcessedData(byte[] data, int offset) {
        if (this.outputSize <= 0) {
            return this.outputSize;
        }
        int i = 0;
        while (i < this.outputSize) {
            int dx = offset + (i << 1);
            data[dx] = (byte)(this.outputData[i] & 0xFF);
            data[dx + 1] = (byte)(this.outputData[i] >> 8 & 0xFF);
            ++i;
        }
        int size = this.outputSize * 2;
        this.outputSize = 0;
        return size;
    }

    public int getProcessedData(short[] data, int offset) {
        if (this.outputSize <= 0) {
            return this.outputSize;
        }
        System.arraycopy(this.outputData, 0, data, offset, this.outputSize);
        int size = this.outputSize;
        this.outputSize = 0;
        return size;
    }

    public int getProcessedDataByteSize() {
        return this.outputSize * 2;
    }

    public void processData(byte[] data, int offset, int len) throws StreamCorruptedException {
        if (data == null) {
            this.processData(true);
        } else {
            this.bits.read_from(data, offset, len);
            this.processData(false);
        }
    }

    public void processData(boolean lost) throws StreamCorruptedException {
        if (lost) {
            this.decoder.decode(null, this.decodedData);
        } else {
            this.decoder.decode(this.bits, this.decodedData);
        }
        if (this.channels == 2) {
            this.decoder.decodeStereo(this.decodedData, this.frameSize);
        }
        int i = 0;
        while (i < this.frameSize * this.channels) {
            if (this.decodedData[i] > 32767.0f) {
                this.decodedData[i] = 32767.0f;
            } else if (this.decodedData[i] < -32768.0f) {
                this.decodedData[i] = -32768.0f;
            }
            ++i;
        }
        i = 0;
        while (i < this.frameSize * this.channels) {
            this.outputData[this.outputSize] = this.decodedData[i] > 0.0f ? (short)((double)this.decodedData[i] + 0.5) : (short)((double)this.decodedData[i] - 0.5);
            ++i;
            ++this.outputSize;
        }
    }
}

