/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hypertalk;

import com.vulpovile.hypertalk.util.Util;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryClient {
    public List<InetAddress> sendDiscoveryRequest(String identifier) {
        int port = 4446;
        DatagramSocket socket = null;
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        try {
            socket = new DatagramSocket(4445);
            socket.setBroadcast(true);
            byte[] sendData = ("DISCOVER_REQUEST:" + identifier).getBytes();
            InetAddress broadcastAddr = InetAddress.getByName("255.255.255.255");
            int i = 0;
            while (i < 3) {
                DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, broadcastAddr, port);
                socket.send(sendPacket);
                Thread.sleep(250L);
                ++i;
            }
            System.out.println("Discovery request sent.");
            byte[] buf = new byte[256];
            socket.setSoTimeout(2000);
            try {
                while (true) {
                    DatagramPacket recvPacket = new DatagramPacket(buf, buf.length);
                    socket.receive(recvPacket);
                    String response = new String(recvPacket.getData(), 0, recvPacket.getLength());
                    if (!response.startsWith("DISCOVER_RESPONSE:")) continue;
                    System.out.println("Discovered: " + recvPacket.getSocketAddress() + "," + recvPacket.getAddress() + " > " + response);
                    InetAddress addr = InetAddress.getByName(response.replace("DISCOVER_RESPONSE:", ""));
                    if (addresses.contains(addr)) continue;
                    addresses.add(addr);
                }
            }
            catch (SocketTimeoutException e) {
                System.out.println("Discovery finished.");
                ArrayList<InetAddress> arrayList = addresses;
                Util.cleanClose(socket);
                return arrayList;
            }
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                Util.cleanClose(socket);
                throw throwable;
            }
            Util.cleanClose(socket);
            return null;
        }
    }
}

