/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hypertalk;

import com.vulpovile.hypertalk.CallProcessor;
import com.vulpovile.hypertalk.ui.CallDialog;
import com.vulpovile.hypertalk.ui.RingDialog;
import com.vulpovile.hypertalk.util.SfxPlayer;
import com.vulpovile.hypertalk.util.Util;
import java.awt.EventQueue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;

public class MessageServer
implements Runnable,
CallProcessor {
    private Thread parentThread;
    public boolean online = false;
    String identifier;
    DatagramSocket socket;
    CallDialog callDialog = null;
    Map<SocketAddress, RingDialog> ringing = Collections.synchronizedMap(new HashMap());

    public void startRinger() {
        if (!this.online && this.parentThread == null) {
            this.parentThread = new Thread(this);
            this.parentThread.start();
        }
    }

    public void stopRinger() {
        this.online = false;
        if (this.parentThread != null) {
            this.parentThread.interrupt();
        }
    }

    public void run() {
        try {
            try {
                int listenPort = 4447;
                this.socket = new DatagramSocket(listenPort, InetAddress.getByName("0.0.0.0"));
                byte[] buf = new byte[4097];
                System.out.println("Message server listening on UDP port " + listenPort);
                while (true) {
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    this.socket.receive(packet);
                    if (packet.getData()[0] == 0) {
                        String received = new String(packet.getData(), 1, packet.getLength() - 1);
                        System.out.println("getting " + received);
                        if (received.startsWith("RING:")) {
                            if (this.callDialog == null) {
                                SfxPlayer.play(this.getClass().getResource("/ringin.wav"));
                                this.setRingDialog(packet.getSocketAddress(), received);
                                continue;
                            }
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            baos.write(0);
                            baos.write("BSY".getBytes());
                            byte[] data = baos.toByteArray();
                            DatagramPacket resp = new DatagramPacket(data, data.length, packet.getSocketAddress());
                            this.socket.send(resp);
                            System.out.println("Sent hang-up after recieving unexpected voice packet");
                            continue;
                        }
                        if (!received.startsWith("HUP") || this.callDialog == null) continue;
                        this.callDialog.hangUpUser();
                        continue;
                    }
                    if (packet.getData()[0] != 1 || this.getVoicePacket(packet.getData(), 1, packet.getLength() - 1)) continue;
                    System.out.println("Sent hang-up after recieving unexpected voice packet");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(null, "Failed to start discovery service, exiting!", "Error", 0);
                System.exit(1);
                Util.cleanClose(this.socket);
                this.socket = null;
            }
        }
        catch (Throwable throwable) {
            Util.cleanClose(this.socket);
            this.socket = null;
            throw throwable;
        }
        this.parentThread = null;
        this.online = false;
    }

    private void setRingDialog(final SocketAddress address, String received) {
        if (this.ringing.containsKey(address)) {
            this.ringing.get(address).resetTimeout();
        } else {
            final String identifier = received.replace("RING:", "");
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    RingDialog ringDialog = new RingDialog(MessageServer.this, address, identifier);
                    MessageServer.this.ringing.put(address, ringDialog);
                    ringDialog.startDialog();
                }
            });
        }
    }

    public void timedOut(RingDialog ringDialog) {
        this.ringing.remove(ringDialog.getInetAddress());
    }

    public void sendHangup(SocketAddress address) {
        this.ringing.remove(address);
        if (this.socket != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(0);
                baos.write("HUP".getBytes());
                byte[] data = baos.toByteArray();
                DatagramPacket packet = new DatagramPacket(data, data.length, address);
                int i = 0;
                while (i < 3) {
                    this.socket.send(packet);
                    System.out.println("Sending hang-up packet");
                    Thread.sleep(250L);
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean getVoicePacket(byte[] voiceBuffer, int offset, int length) {
        if (this.callDialog == null) {
            return false;
        }
        this.callDialog.voice(voiceBuffer, offset, length);
        return true;
    }

    public boolean sendVoicePacket(byte[] buffer, int length, SocketAddress address) {
        if (this.socket == null || this.callDialog == null) {
            return false;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(1);
        baos.write(buffer, 0, length);
        byte[] data = baos.toByteArray();
        try {
            DatagramPacket packet = new DatagramPacket(data, data.length, address);
            this.socket.send(packet);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public void callHungUp() {
        this.callDialog = null;
    }

    public void acceptCall(SocketAddress address, String identifier) {
        this.ringing.remove(address);
        try {
            this.callDialog = new CallDialog(this, identifier, address);
            this.callDialog.beginCall();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(0);
            baos.write("ACC".getBytes());
            byte[] data = baos.toByteArray();
            DatagramPacket packet = new DatagramPacket(data, data.length, address);
            int i = 0;
            while (i < 3) {
                this.socket.send(packet);
                Thread.sleep(250L);
                ++i;
            }
        }
        catch (Exception ex) {
            this.callDialog.hangUp();
        }
    }

    public void ringStopped(SocketAddress address) {
        this.ringing.remove(address);
    }
}

