/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hypertalk;

public class uLaw {
    public static short uLawToLinearSample(byte ulawByte) {
        ulawByte = ~ulawByte;
        int sign = ulawByte & 0x80;
        int exponent = ulawByte >> 4 & 7;
        int mantissa = ulawByte & 0xF;
        int sample = (mantissa << 3) + 132 << exponent;
        return (short)(sign == 0 ? sample : -(sample -= 132));
    }

    public static byte[] decode(byte[] ulaw) {
        byte[] pcm16 = new byte[ulaw.length * 2];
        int i = 0;
        while (i < ulaw.length) {
            short sample16 = uLaw.uLawToLinearSample(ulaw[i]);
            pcm16[i << 1] = (byte)(sample16 & 0xFF);
            pcm16[(i << 1) + 1] = (byte)(sample16 >> 8 & 0xFF);
            ++i;
        }
        return pcm16;
    }

    public static byte linearToULawSample(short sample) {
        int MAX = 32635;
        int sign = sample >> 8 & 0x80;
        if (sign != 0) {
            sample = -sample;
        }
        if (sample > 32635) {
            sample = (short)32635;
        }
        sample = (short)(sample + 132);
        int exponent = 7;
        int expMask = 16384;
        while ((sample & expMask) == 0 && exponent > 0) {
            --exponent;
            expMask >>= 1;
        }
        int mantissa = sample >> (exponent == 0 ? 4 : exponent + 3) & 0xF;
        int ulawByte = ~(sign | exponent << 4 | mantissa);
        return (byte)ulawByte;
    }

    public static byte[] encode(byte[] pcm16, int count) {
        int samples = count / 2;
        byte[] ulaw = new byte[samples];
        int i = 0;
        while (i < samples) {
            int low = pcm16[i << 1] & 0xFF;
            byte high = pcm16[(i << 1) + 1];
            short sample16 = (short)(high << 8 | low);
            ulaw[i] = uLaw.linearToULawSample(sample16);
            ++i;
        }
        return ulaw;
    }
}

