/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hypertalk.ui;

import com.vulpovile.hypertalk.CallProcessor;
import com.vulpovile.hypertalk.uLaw;
import com.vulpovile.hypertalk.util.SfxPlayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.SocketAddress;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

public class CallDialog
extends JFrame
implements Runnable {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    public boolean hungup = true;
    CallProcessor callProcessor;
    SocketAddress socketAddress;
    SourceDataLine speaker = null;
    Thread parentThread = null;
    Timer timer;
    long lastPacketTime = 0L;

    public CallDialog(CallProcessor callProcessor, String identifier, SocketAddress socketAddress) {
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 318, 70);
        this.callProcessor = callProcessor;
        this.socketAddress = socketAddress;
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JLabel lblInCallWith = new JLabel("In call with " + identifier);
        this.contentPane.add((Component)lblInCallWith, "West");
        JButton btnHangUp = new JButton("Hang Up");
        btnHangUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                CallDialog.this.callProcessor.sendHangup(CallDialog.this.socketAddress);
                CallDialog.this.hangUp();
            }
        });
        this.contentPane.add((Component)btnHangUp, "East");
    }

    public void beginCall() {
        if (this.hungup && this.speaker == null) {
            SfxPlayer.play(this.getClass().getResource("/pup.wav"));
            this.lastPacketTime = System.currentTimeMillis();
            this.hungup = false;
            this.timer = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (System.currentTimeMillis() - CallDialog.this.lastPacketTime > 3000L) {
                        CallDialog.this.hangUpUser();
                    }
                }
            });
            this.parentThread = new Thread(this);
            this.parentThread.start();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    CallDialog.this.setVisible(true);
                }
            });
        }
    }

    public void hangUp() {
        if (!this.hungup) {
            SfxPlayer.play(this.getClass().getResource("/hup.wav"));
            this.hungup = true;
            this.timer.stop();
            this.timer = null;
            if (this.parentThread != null) {
                this.parentThread.interrupt();
                this.callProcessor.callHungUp();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        CallDialog.this.dispose();
                    }
                });
            }
        }
    }

    public void run() {
        block12: {
            this.timer.start();
            AudioFormat format = new AudioFormat(8000.0f, 16, 1, true, false);
            DataLine microphone = null;
            try {
                try {
                    this.speaker = AudioSystem.getSourceDataLine(format);
                    microphone = AudioSystem.getTargetDataLine(format);
                    this.speaker.open(format);
                    this.speaker.start();
                    microphone.open(format);
                    microphone.start();
                    byte[] buffer = new byte[1024];
                    System.out.println("Recording...");
                    while (!this.hungup) {
                        int count = microphone.read(buffer, 0, buffer.length);
                        if (count <= 0) continue;
                        byte[] compressed = uLaw.encode(buffer, count);
                        this.callProcessor.sendVoicePacket(compressed, compressed.length, this.socketAddress);
                    }
                }
                catch (Exception ex) {
                    this.callProcessor.sendHangup(this.socketAddress);
                    this.hungup = true;
                    if (microphone != null) {
                        microphone.stop();
                        microphone.close();
                    }
                    if (this.speaker != null) {
                        this.speaker.stop();
                        this.speaker.close();
                        this.speaker = null;
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (microphone != null) {
                    microphone.stop();
                    microphone.close();
                }
                if (this.speaker != null) {
                    this.speaker.stop();
                    this.speaker.close();
                    this.speaker = null;
                }
                throw throwable;
            }
            if (microphone != null) {
                microphone.stop();
                microphone.close();
            }
            if (this.speaker != null) {
                this.speaker.stop();
                this.speaker.close();
                this.speaker = null;
            }
        }
        this.hangUp();
        this.parentThread = null;
        System.out.println("Recording stopped");
    }

    public void voice(byte[] voiceBuffer, int offset, int length) {
        if (this.speaker != null) {
            this.lastPacketTime = System.currentTimeMillis();
            byte[] buffer = new byte[length];
            System.arraycopy(voiceBuffer, offset, buffer, 0, length);
            buffer = uLaw.decode(buffer);
            this.speaker.write(buffer, 0, buffer.length);
        }
    }

    public void hangUpUser() {
        this.hangUp();
        JOptionPane.showMessageDialog(null, "User hung up", "Call comlete", 1);
    }
}

