/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hypertalk.ui;

import com.vulpovile.hypertalk.CallProcessor;
import com.vulpovile.hypertalk.DiscoveryClient;
import com.vulpovile.hypertalk.MainInterface;
import com.vulpovile.hypertalk.ui.CallDialog;
import com.vulpovile.hypertalk.util.SfxPlayer;
import com.vulpovile.hypertalk.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class CallInitializer
extends JDialog
implements Runnable,
CallProcessor {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    String identifier;
    String self;
    MainInterface main;
    DatagramSocket socket;
    CallDialog callDialog;
    JLabel lblDialing = new JLabel();

    public CallInitializer(MainInterface parent, String identifier, String self) {
        super(parent);
        this.main = parent;
        this.identifier = identifier;
        this.self = self;
        this.setModal(false);
        this.setTitle("Dialing " + identifier + "...");
        this.setBounds(100, 100, 450, 76);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setLayout(new FlowLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.lblDialing.setText("Dialing " + identifier + "...");
        this.contentPanel.add(this.lblDialing);
        this.setLocationRelativeTo(null);
    }

    public void beginCalling() {
        this.main.setCallable(false);
        this.setVisible(true);
        new Thread(this).start();
    }

    public void failure(final String message, final String title, final int error) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                CallInitializer.this.dispose();
                CallInitializer.this.main.setCallable(true);
                JOptionPane.showMessageDialog(CallInitializer.this.main, message, title, error);
            }
        });
    }

    public void run() {
        List<InetAddress> addresses = new DiscoveryClient().sendDiscoveryRequest(this.identifier);
        if (addresses == null) {
            this.failure("Failed to send discovery request", "Error", 0);
        } else if (addresses.size() <= 0) {
            this.failure("User " + this.identifier + " not found or is not accepting calls at this time.", "Failed to connect", 1);
        } else if (addresses.size() > 1) {
            this.failure("User " + this.identifier + " ambiguous", "Failed to connect", 1);
        } else {
            DatagramSocket socket = null;
            this.lblDialing.setText("Ringing " + this.identifier + "...");
            try {
                socket = new DatagramSocket(4448);
                byte[] ringData = ("RING:" + this.self).getBytes();
                byte[] ringPacket = new byte[ringData.length + 1];
                ringPacket[0] = 0;
                System.arraycopy(ringData, 0, ringPacket, 1, ringData.length);
                DatagramPacket datagramPacket = new DatagramPacket(ringPacket, ringPacket.length, addresses.get(0), 4447);
                int i = 0;
                while (i < 10) {
                    if ((i & 1) > 0) {
                        SfxPlayer.play(this.getClass().getResource("/ringout.wav"));
                    }
                    socket.send(datagramPacket);
                    socket.setSoTimeout(1000);
                    byte[] responseBuffer = new byte[4097];
                    DatagramPacket recv = new DatagramPacket(responseBuffer, responseBuffer.length);
                    try {
                        if (recv.getData()[0] == 0) {
                            socket.receive(recv);
                            String data = new String(recv.getData(), 1, recv.getLength() - 1);
                            System.out.println("Got " + data);
                            if (data.startsWith("HUP")) {
                                this.failure("User rejected the call.", "Could not initiate call", 1);
                                SfxPlayer.play(this.getClass().getResource("/hup.wav"));
                                return;
                            }
                            if (data.startsWith("HUP")) {
                                this.failure("User currently in another call.", "Could not initiate call", 1);
                                SfxPlayer.play(this.getClass().getResource("/bsy.wav"), 2);
                                return;
                            }
                            if (data.startsWith("ACC")) {
                                System.out.println("Accepting call!");
                                this.startCall(socket, recv.getSocketAddress());
                                return;
                            }
                        }
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        // empty catch block
                    }
                    ++i;
                }
                this.failure("User did not answer", "Could not initiate call", 1);
                Util.cleanClose(socket);
            }
            catch (SocketException e) {
                e.printStackTrace();
                Util.cleanClose(socket);
            }
            catch (IOException e) {
                e.printStackTrace();
                Util.cleanClose(socket);
            }
        }
    }

    private void startCall(DatagramSocket socket, SocketAddress socketAddress) {
        this.socket = socket;
        this.callDialog = new CallDialog(this, this.identifier, socketAddress);
        this.callDialog.beginCall();
        this.dispose();
        while (this.callDialog != null) {
            byte[] buffer = new byte[4097];
            DatagramPacket recv = new DatagramPacket(buffer, buffer.length);
            try {
                socket.receive(recv);
                if (recv.getData()[0] == 0) {
                    String data = new String(recv.getData(), 1, recv.getLength() - 1);
                    if (!data.startsWith("HUP") || this.callDialog == null) continue;
                    this.callDialog.hangUp();
                    continue;
                }
                if (recv.getData()[0] != 1 || this.getVoicePacket(recv.getData(), 1, recv.getLength() - 1)) continue;
                this.sendHangup(recv.getSocketAddress());
            }
            catch (SocketTimeoutException data) {
            }
            catch (IOException e) {
                e.printStackTrace();
                if (this.callDialog == null) continue;
                this.callDialog.hangUp();
            }
        }
        Util.cleanClose(socket);
        this.socket = null;
    }

    public void sendHangup(SocketAddress address) {
        if (this.socket != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(0);
                baos.write("HUP".getBytes());
                byte[] data = baos.toByteArray();
                DatagramPacket packet = new DatagramPacket(data, data.length, address);
                int i = 0;
                while (i < 3) {
                    this.socket.send(packet);
                    System.out.println("Sending hang-up packet");
                    Thread.sleep(250L);
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean getVoicePacket(byte[] voiceBuffer, int offset, int length) {
        if (this.callDialog == null) {
            return false;
        }
        this.callDialog.voice(voiceBuffer, offset, length);
        return true;
    }

    public boolean sendVoicePacket(byte[] buffer, int length, SocketAddress address) {
        if (this.socket == null || this.callDialog == null) {
            return false;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(1);
        baos.write(buffer, 0, length);
        byte[] data = baos.toByteArray();
        try {
            DatagramPacket packet = new DatagramPacket(data, data.length, address);
            this.socket.send(packet);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public void callHungUp() {
        this.callDialog = null;
        this.main.setCallable(true);
        Util.cleanClose(this.socket);
        this.socket = null;
    }
}

