/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hypertalk.ui;

import com.vulpovile.hypertalk.MessageServer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.SocketAddress;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class RingDialog
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    long timeout = 3L;
    MessageServer messageServer;
    SocketAddress address;
    String name;
    Timer timer = null;
    JButton btnAccept = new JButton("Accept");
    JButton btnDecline = new JButton("Cancel");

    public RingDialog(MessageServer messageServer, SocketAddress address, String name) {
        this.messageServer = messageServer;
        this.address = address;
        this.name = name;
        this.setBounds(100, 100, 450, 73);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "Center");
        this.btnAccept.setActionCommand("OK");
        buttonPane.add(this.btnAccept);
        this.getRootPane().setDefaultButton(this.btnAccept);
        this.btnDecline.setActionCommand("Cancel");
        buttonPane.add(this.btnDecline);
        JLabel lblIncomingCallFrom = new JLabel("Incoming call from " + name);
        this.getContentPane().add((Component)lblIncomingCallFrom, "West");
        this.setDefaultCloseOperation(0);
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        Insets toolHeight = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        int x = scrSize.width - this.getWidth() - toolHeight.right;
        int y = scrSize.height - this.getHeight() - toolHeight.bottom;
        this.setLocation(x, y);
        this.setAlwaysOnTop(true);
        this.btnDecline.addActionListener(this);
        this.btnAccept.addActionListener(this);
    }

    public void startDialog() {
        this.setVisible(true);
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RingDialog.this.repaint();
                --RingDialog.this.timeout;
                if (RingDialog.this.timeout <= 0L) {
                    RingDialog.this.stopDialog();
                }
            }
        });
        this.timer.start();
    }

    public void stopDialog() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.messageServer.ringStopped(this.address);
        this.dispose();
    }

    public void resetTimeout() {
        this.timeout = 3L;
    }

    public SocketAddress getInetAddress() {
        return this.address;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnDecline) {
            this.messageServer.sendHangup(this.address);
        } else if (e.getSource() == this.btnAccept) {
            this.messageServer.acceptCall(this.address, this.name);
        }
    }
}

