/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hypertalk.util;

import com.vulpovile.hypertalk.util.Util;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

public class SfxPlayer {
    public static void play(URL resource) {
        SfxPlayer.play(resource, 0);
    }

    public static void play(URL resource, int loop) {
        AudioInputStream audioIn = null;
        try {
            final AudioInputStream finalIn = audioIn = AudioSystem.getAudioInputStream(resource);
            final Clip clip = AudioSystem.getClip();
            clip.open(audioIn);
            clip.loop(loop);
            clip.addLineListener(new LineListener(){

                public void update(LineEvent event) {
                    if (event.getType() == LineEvent.Type.STOP) {
                        clip.close();
                        Util.cleanClose(finalIn);
                    }
                }
            });
            clip.start();
            System.out.println("Playing async...");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Util.cleanClose(audioIn);
        }
    }
}

