/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.xiph.speex.AudioFileWriter;
import org.xiph.speex.OggCrc;

public class OggSpeexWriter
extends AudioFileWriter {
    public static final int PACKETS_PER_OGG_PAGE = 250;
    private OutputStream out;
    private int mode;
    private int sampleRate;
    private int channels;
    private int nframes;
    private boolean vbr;
    private int streamSerialNumber;
    private byte[] dataBuffer;
    private int dataBufferPtr;
    private byte[] headerBuffer;
    private int headerBufferPtr;
    private int pageCount;
    private int packetCount;
    private long granulepos;

    public OggSpeexWriter() {
        if (this.streamSerialNumber == 0) {
            this.streamSerialNumber = new Random().nextInt();
        }
        this.dataBuffer = new byte[65565];
        this.dataBufferPtr = 0;
        this.headerBuffer = new byte[255];
        this.headerBufferPtr = 0;
        this.pageCount = 0;
        this.packetCount = 0;
        this.granulepos = 0L;
    }

    public OggSpeexWriter(int mode, int sampleRate, int channels, int nframes, boolean vbr) {
        this();
        this.setFormat(mode, sampleRate, channels, nframes, vbr);
    }

    private void setFormat(int mode, int sampleRate, int channels, int nframes, boolean vbr) {
        this.mode = mode;
        this.sampleRate = sampleRate;
        this.channels = channels;
        this.nframes = nframes;
        this.vbr = vbr;
    }

    public void setSerialNumber(int serialNumber) {
        this.streamSerialNumber = serialNumber;
    }

    public void close() throws IOException {
        this.flush(true);
        this.out.close();
    }

    public void open(File file) throws IOException {
        file.delete();
        this.out = new FileOutputStream(file);
    }

    public void open(String filename) throws IOException {
        this.open(new File(filename));
    }

    public void writeHeader(String comment) throws IOException {
        byte[] header = OggSpeexWriter.buildOggPageHeader(2, 0L, this.streamSerialNumber, this.pageCount++, 1, new byte[]{80});
        byte[] data = OggSpeexWriter.buildSpeexHeader(this.sampleRate, this.mode, this.channels, this.vbr, this.nframes);
        int chksum = OggCrc.checksum(0, header, 0, header.length);
        chksum = OggCrc.checksum(chksum, data, 0, data.length);
        OggSpeexWriter.writeInt(header, 22, chksum);
        this.out.write(header);
        this.out.write(data);
        header = OggSpeexWriter.buildOggPageHeader(0, 0L, this.streamSerialNumber, this.pageCount++, 1, new byte[]{(byte)(comment.length() + 8)});
        data = OggSpeexWriter.buildSpeexComment(comment);
        chksum = OggCrc.checksum(0, header, 0, header.length);
        chksum = OggCrc.checksum(chksum, data, 0, data.length);
        OggSpeexWriter.writeInt(header, 22, chksum);
        this.out.write(header);
        this.out.write(data);
    }

    public void writePacket(byte[] data, int offset, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        if (this.packetCount > 250) {
            this.flush(false);
        }
        System.arraycopy(data, offset, this.dataBuffer, this.dataBufferPtr, len);
        this.dataBufferPtr += len;
        this.headerBuffer[this.headerBufferPtr++] = (byte)len;
        ++this.packetCount;
        this.granulepos += (long)(this.nframes * (this.mode == 2 ? 640 : (this.mode == 1 ? 320 : 160)));
    }

    private void flush(boolean eos) throws IOException {
        byte[] header = OggSpeexWriter.buildOggPageHeader(eos ? 4 : 0, this.granulepos, this.streamSerialNumber, this.pageCount++, this.packetCount, this.headerBuffer);
        int chksum = OggCrc.checksum(0, header, 0, header.length);
        chksum = OggCrc.checksum(chksum, this.dataBuffer, 0, this.dataBufferPtr);
        OggSpeexWriter.writeInt(header, 22, chksum);
        this.out.write(header);
        this.out.write(this.dataBuffer, 0, this.dataBufferPtr);
        this.dataBufferPtr = 0;
        this.headerBufferPtr = 0;
        this.packetCount = 0;
    }
}

