/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.DecompressingEntity;
import org.apache.http.client.entity.DeflateInputStream;
import org.apache.http.client.entity.InputStreamFactory;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";
    private static final InputStreamFactory GZIP = new InputStreamFactory(){

        public InputStream create(InputStream instream) throws IOException {
            return new GZIPInputStream(instream);
        }
    };
    private static final InputStreamFactory DEFLATE = new InputStreamFactory(){

        public InputStream create(InputStream instream) throws IOException {
            return new DeflateInputStream(instream);
        }
    };
    private final Lookup<InputStreamFactory> decoderRegistry;

    public ResponseContentEncoding(Lookup<InputStreamFactory> decoderRegistry) {
        this.decoderRegistry = decoderRegistry != null ? decoderRegistry : RegistryBuilder.create().register("gzip", GZIP).register("x-gzip", GZIP).register("deflate", DEFLATE).build();
    }

    public ResponseContentEncoding() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Header ceheader;
        HttpEntity entity = response.getEntity();
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig requestConfig = clientContext.getRequestConfig();
        if (requestConfig.isDecompressionEnabled() && entity != null && entity.getContentLength() != 0L && (ceheader = entity.getContentEncoding()) != null) {
            HeaderElement[] codecs;
            HeaderElement[] headerElementArray = codecs = ceheader.getElements();
            int n = codecs.length;
            int n2 = 0;
            while (n2 < n) {
                HeaderElement codec = headerElementArray[n2];
                String codecname = codec.getName().toLowerCase(Locale.ENGLISH);
                InputStreamFactory decoderFactory = this.decoderRegistry.lookup(codecname);
                if (decoderFactory != null) {
                    response.setEntity(new DecompressingEntity(response.getEntity(), decoderFactory));
                    response.removeHeaders("Content-Length");
                    response.removeHeaders("Content-Encoding");
                    response.removeHeaders("Content-MD5");
                } else if (!"identity".equals(codecname)) {
                    throw new HttpException("Unsupported Content-Coding: " + codec.getName());
                }
                ++n2;
            }
        }
    }
}

