/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

public class WrapperDetector {
    protected static String[][] classRules = new String[][]{{"rd", "com.mojang.rubydung.RubyDung"}, {"mc", "com.mojang.minecraft.RubyDung", "com.mojang.minecraft.MinecraftApplet"}, {"classic12a", "com.mojang.minecraft.MinecraftApplet", "com.mojang.minecraft.server.MinecraftServer", "!com.mojang.minecraft.User"}, {"classic", "com.mojang.minecraft.MinecraftApplet", "!com.mojang.minecraft.net.NetworkPlayer"}, {"classic15a", "com.mojang.minecraft.MinecraftApplet", "com.mojang.minecraft.net.NetworkPlayer", "!com.mojang.minecraft.e"}, {"classicmp", "com.mojang.minecraft.MinecraftApplet", "com.mojang.minecraft.net.NetworkPlayer"}, {"4k", "M"}, {"indev", "net.minecraft.client.MinecraftApplet"}, {"1.6", "net.minecraft.client.main.Main"}};

    public static String getLaunchMethod(String versionpath) {
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{new File(versionpath).toURI().toURL()});
            String[][] stringArray = classRules;
            int n = classRules.length;
            int n2 = 0;
            while (n2 < n) {
                String[] arg0 = stringArray[n2];
                String launchmethod = arg0[0];
                boolean passes = true;
                int i = 1;
                while (i < arg0.length) {
                    passes = WrapperDetector.testClass(arg0[i], loader);
                    if (!passes) {
                        passes = false;
                        break;
                    }
                    ++i;
                }
                if (passes) {
                    System.out.println("Detected launch method: " + launchmethod);
                    return launchmethod;
                }
                ++n2;
            }
        }
        finally {
            return "custom";
        }
    }

    public static boolean testClass(String path, ClassLoader loader) {
        boolean pass = true;
        if (path.startsWith("!")) {
            path = path.substring(1);
            pass = !pass;
        }
        try {
            Class.forName(path, false, loader);
        }
        catch (ClassNotFoundException ex) {
            return !pass;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return pass;
    }
}

