/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import org.betacraft.launcher.BC;
import org.betacraft.launcher.Lang;
import org.betacraft.launcher.WebsitePanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Addon {
    public static String addonVer = "1.09_16";
    public String name;
    public String onlinehash;
    public boolean online;
    public JScrollPane info;
    public static HashMap<String, Addon> addons = new HashMap();

    public Addon(String name, String hash, boolean online) {
        this.name = name;
        this.onlinehash = hash;
        this.online = online;
        this.info = this.getInfo();
    }

    public JScrollPane getInfo() {
        JEditorPane pane = new JEditorPane();
        pane.setEditable(false);
        pane.setOpaque(false);
        pane.setContentType("text/html;charset=UTF-8");
        pane.addHyperlinkListener(WebsitePanel.EXTERNAL_HYPERLINK_LISTENER);
        try {
            pane.setPage(new URL("http://files.betacraft.uk/launcher/assets/addons/" + addonVer + "/" + this.name + ".html"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            pane.setText(Lang.ADDON_NO_DESC);
        }
        JScrollPane scrlPane = new JScrollPane(pane);
        scrlPane.setBorder(null);
        scrlPane.setWheelScrollingEnabled(true);
        return scrlPane;
    }

    public static void loadAddons() {
        try {
            String[] offlineAddons = new File(String.valueOf(BC.get()) + "launcher" + File.separator + "addons" + File.separator).list(new FilenameFilter(){

                public boolean accept(File dir, String fileName) {
                    return fileName.endsWith(".jar");
                }
            });
            URL url = new URL("http://files.betacraft.uk/launcher/assets/addons/" + addonVer + "/list.txt");
            InputStream onlineListStream = null;
            try {
                onlineListStream = url.openStream();
            }
            catch (UnknownHostException ex) {
                System.out.println("No connection, or the server is down");
            }
            catch (SocketTimeoutException ex) {
                System.out.println("No connection, or the server is down");
            }
            catch (SocketException ex) {
                System.out.println("No connection, or the server is down");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (onlineListStream == null) {
                String[] stringArray = offlineAddons;
                int n = offlineAddons.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    String name = s.substring(0, s.length() - 4);
                    addons.put(name, new Addon(name, null, false));
                    ++n2;
                }
                return;
            }
            Scanner onlineListScanner = new Scanner(onlineListStream, "UTF-8");
            for (String ver : Addon.scan(onlineListScanner)) {
                if (ver == null) continue;
                String[] split = ver.split("`");
                String addonname = split[0];
                String addonhash = split[1];
                int i = 0;
                while (i < offlineAddons.length) {
                    if (offlineAddons[i] != null && offlineAddons[i].substring(0, offlineAddons[i].length() - 4).equals(addonname)) {
                        offlineAddons[i] = null;
                    }
                    ++i;
                }
                addons.put(addonname, new Addon(addonname, addonhash, true));
            }
            int i = 0;
            while (i < offlineAddons.length) {
                if (offlineAddons[i] != null) {
                    String name = offlineAddons[i].substring(0, offlineAddons[i].length() - 4);
                    addons.put(name, new Addon(name, null, false));
                }
                ++i;
            }
            onlineListScanner.close();
            onlineListStream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected static List<String> scan(Scanner scanner) {
        ArrayList<String> results = new ArrayList<String>();
        String currentLine = null;
        while (scanner.hasNextLine()) {
            currentLine = scanner.nextLine();
            if (currentLine.equalsIgnoreCase("")) continue;
            results.add(currentLine);
        }
        return results;
    }
}

