/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.JTextComponent;
import org.betacraft.launcher.InstanceSettings;
import org.betacraft.launcher.Lang;
import org.betacraft.launcher.Window;
import uk.betacraft.auth.Credentials;
import uk.betacraft.auth.MicrosoftAuth;
import uk.betacraft.auth.jsons.microsoft.CheckTokenRequest;
import uk.betacraft.auth.jsons.microsoft.CheckTokenResponse;

public class AwaitingMSALogin
extends JFrame {
    private String usercode;
    private String devcode;
    private String url;
    private long pass;
    private int interval;
    public CheckThread checkThread;
    public static MouseListener autofocus = new MouseListener(){

        public void mouseClicked(MouseEvent e) {
            if (e.getSource() instanceof JTextComponent) {
                ((JTextComponent)e.getSource()).selectAll();
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    };

    public AwaitingMSALogin(String url, String userCode, String devCode, long time, int interval) {
        this.url = url;
        this.usercode = userCode;
        this.devcode = devCode;
        this.pass = System.currentTimeMillis() + time * 1000L;
        this.interval = interval;
        this.setIconImage(Window.img);
        this.setTitle(Lang.LOGIN_MICROSOFT_TITLE);
        this.setResizable(true);
        this.setMinimumSize(new Dimension(360, 200));
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.gridwidth = 3;
        constr.weightx = 0.0;
        constr.fill = 2;
        constr.insets = new Insets(10, 10, 0, 10);
        InstanceSettings.OptionsPanel panel = new InstanceSettings.OptionsPanel();
        panel.setLayout(new GridBagLayout());
        JLabel label1 = new JLabel(Lang.LOGIN_MICROSOFT_CODE_LINE1);
        label1.setForeground(Color.LIGHT_GRAY);
        JTextField tf = new JTextField(this.url);
        tf.setEditable(false);
        tf.addMouseListener(autofocus);
        JLabel label2 = new JLabel(Lang.LOGIN_MICROSOFT_CODE_LINE2);
        label2.setForeground(Color.LIGHT_GRAY);
        JTextPane tp = new JTextPane();
        tp.setEditable(false);
        tp.setText(this.usercode);
        tp.setOpaque(false);
        tp.setForeground(Color.LIGHT_GRAY);
        tp.setBorder(null);
        tp.setFont(new Font("Courier New", 1, 20));
        tp.setDisabledTextColor(Color.WHITE);
        tp.addMouseListener(autofocus);
        panel.add((Component)label1, constr);
        ++constr.gridy;
        constr.weightx = 1.0;
        panel.add((Component)tf, constr);
        constr.weightx = 0.0;
        ++constr.gridy;
        panel.add((Component)label2, constr);
        ++constr.gridy;
        panel.add((Component)tp, constr);
        JPanel cancel = new JPanel();
        cancel.setLayout(new GridBagLayout());
        ++constr.gridy;
        constr.gridx = 0;
        constr.insets = new Insets(2, 2, 2, 2);
        constr.gridheight = 1;
        constr.weightx = 1.0;
        JButton cancelButton = new JButton(Lang.CANCEL);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (AwaitingMSALogin.this.checkThread != null) {
                    AwaitingMSALogin.this.checkThread.interrupt();
                }
                AwaitingMSALogin.this.dispose();
            }
        });
        cancelButton.setBackground(Color.WHITE);
        cancel.add((Component)cancelButton, constr);
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)cancel, "Last");
        this.pack();
        this.setLocationRelativeTo(Window.mainWindow);
        this.setVisible(true);
        this.checkThread = new CheckThread();
        this.checkThread.start();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (AwaitingMSALogin.this.checkThread != null) {
                    AwaitingMSALogin.this.checkThread.interrupt();
                }
                AwaitingMSALogin.this.dispose();
            }
        });
    }

    public class CheckThread
    extends Thread {
        public void run() {
            try {
                while (AwaitingMSALogin.this.pass > System.currentTimeMillis()) {
                    CheckTokenResponse ctr = new CheckTokenRequest(AwaitingMSALogin.this.devcode, null).perform();
                    if (ctr != null) {
                        if (ctr.error != null) {
                            System.out.println("MSA Error: " + ctr.error);
                            System.out.println("Err msg: " + ctr.error_description);
                            System.out.println("Err codes: ");
                            int[] nArray = ctr.error_codes;
                            int n = ctr.error_codes.length;
                            int n2 = 0;
                            while (n2 < n) {
                                int code = nArray[n2];
                                System.out.print(String.valueOf(code) + " ");
                                ++n2;
                            }
                        } else {
                            Credentials cred = new Credentials();
                            cred.refresh_token = ctr.refresh_token;
                            MicrosoftAuth msa = new MicrosoftAuth(cred);
                            Window.continueMSA(msa);
                            break;
                        }
                    }
                    Thread.sleep(AwaitingMSALogin.this.interval * 1000);
                }
                AwaitingMSALogin.this.dispose();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

