/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.SimpleDateFormat;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.betacraft.launcher.Lang;
import org.betacraft.launcher.Launcher;

public class ConsoleLogFrame
extends JFrame {
    static SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
    BufferedImage iconImg;
    JButton copy;
    JButton clear;
    JButton pause;
    JTextArea logArea;
    boolean enabled;
    boolean paused = false;
    String buffer = "";
    String pauseBuffer = "";

    public ConsoleLogFrame(String instancename, boolean enabled) {
        this.enabled = enabled;
        if (!this.enabled) {
            return;
        }
        try {
            this.iconImg = ImageIO.read(Launcher.class.getResource("/icons/console.png"));
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return;
        }
        this.setIconImage(this.iconImg);
        this.setTitle(String.format(Lang.CONSOLE_OUTPUT_FOR, instancename));
        this.setMinimumSize(new Dimension(640, 640));
        this.setPreferredSize(new Dimension(1080, 720));
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 5, 5));
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.fill = 1;
        constr.anchor = 17;
        constr.gridwidth = 1;
        constr.weightx = 0.0;
        constr.insets = new Insets(10, 5, 10, 5);
        this.copy = new JButton(Lang.COPY);
        this.copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StringSelection selection = new StringSelection(ConsoleLogFrame.this.buffer);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            }
        });
        panel.add(this.copy);
        ++constr.gridx;
        this.pause = new JButton(Lang.PAUSE);
        this.pause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean bl = ConsoleLogFrame.this.paused = !ConsoleLogFrame.this.paused;
                if (ConsoleLogFrame.this.paused) {
                    ConsoleLogFrame.this.pause.setText(Lang.UNPAUSE);
                } else {
                    ConsoleLogFrame.this.print(ConsoleLogFrame.this.pauseBuffer);
                    ConsoleLogFrame.this.pauseBuffer = "";
                    ConsoleLogFrame.this.pause.setText(Lang.PAUSE);
                }
            }
        });
        panel.add(this.pause);
        ++constr.gridx;
        this.clear = new JButton(Lang.CLEAR);
        this.clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConsoleLogFrame.this.clear();
            }
        });
        panel.add(this.clear);
        panel.setBackground(new Color(22, 22, 22));
        this.logArea = new JTextArea();
        this.logArea.setFont(new Font("Consolas", 0, 12));
        this.logArea.setForeground(Color.LIGHT_GRAY);
        this.logArea.setBackground(new Color(22, 22, 22));
        this.logArea.setLineWrap(true);
        this.logArea.setWrapStyleWord(true);
        this.logArea.setCaretColor(Color.WHITE);
        this.logArea.setEditable(false);
        JScrollPane scroll = new JScrollPane(this.logArea);
        scroll.setWheelScrollingEnabled(true);
        this.getContentPane().add((Component)panel, "North");
        this.getContentPane().add((Component)scroll, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void clear() {
        if (!this.enabled) {
            return;
        }
        this.buffer = "";
        this.pauseBuffer = "";
        this.logArea.setText("");
        this.logArea.setCaretPosition(this.logArea.getDocument().getLength());
    }

    public void print(String text) {
        if (!this.enabled) {
            return;
        }
        this.logArea.append(text);
        this.logArea.setCaretPosition(this.logArea.getDocument().getLength());
    }

    public void log(String text) {
        if (!this.enabled) {
            return;
        }
        String date = format.format(System.currentTimeMillis());
        text = "(" + date + ") " + text;
        this.buffer = String.valueOf(this.buffer) + text;
        if (!this.paused) {
            this.print(text);
        } else {
            this.pauseBuffer = String.valueOf(this.pauseBuffer) + text;
        }
    }
}

