/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;

public final class SessionParameters {
    private int cipherSuite;
    private short compressionAlgorithm;
    private Certificate localCertificate;
    private TlsSecret masterSecret;
    private ProtocolVersion negotiatedVersion;
    private Certificate peerCertificate;
    private byte[] pskIdentity = null;
    private byte[] srpIdentity = null;
    private byte[] encodedServerExtensions;
    private boolean extendedMasterSecret;

    private SessionParameters(int n, short s, Certificate certificate, TlsSecret tlsSecret, ProtocolVersion protocolVersion, Certificate certificate2, byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl) {
        this.cipherSuite = n;
        this.compressionAlgorithm = s;
        this.localCertificate = certificate;
        this.masterSecret = tlsSecret;
        this.negotiatedVersion = protocolVersion;
        this.peerCertificate = certificate2;
        this.pskIdentity = Arrays.clone(byArray);
        this.srpIdentity = Arrays.clone(byArray2);
        this.encodedServerExtensions = byArray3;
        this.extendedMasterSecret = bl;
    }

    public void clear() {
        if (this.masterSecret != null) {
            this.masterSecret.destroy();
        }
    }

    public SessionParameters copy() {
        return new SessionParameters(this.cipherSuite, this.compressionAlgorithm, this.localCertificate, this.masterSecret, this.negotiatedVersion, this.peerCertificate, this.pskIdentity, this.srpIdentity, this.encodedServerExtensions, this.extendedMasterSecret);
    }

    public int getCipherSuite() {
        return this.cipherSuite;
    }

    public short getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public Certificate getLocalCertificate() {
        return this.localCertificate;
    }

    public TlsSecret getMasterSecret() {
        return this.masterSecret;
    }

    public ProtocolVersion getNegotiatedVersion() {
        return this.negotiatedVersion;
    }

    public Certificate getPeerCertificate() {
        return this.peerCertificate;
    }

    public byte[] getPSKIdentity() {
        return this.pskIdentity;
    }

    public byte[] getSRPIdentity() {
        return this.srpIdentity;
    }

    public boolean isExtendedMasterSecret() {
        return this.extendedMasterSecret;
    }

    public Hashtable readServerExtensions() throws IOException {
        if (this.encodedServerExtensions == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.encodedServerExtensions);
        return TlsProtocol.readExtensions(byteArrayInputStream);
    }

    public static final class Builder {
        private int cipherSuite = -1;
        private short compressionAlgorithm = (short)-1;
        private Certificate localCertificate = null;
        private TlsSecret masterSecret = null;
        private ProtocolVersion negotiatedVersion;
        private Certificate peerCertificate = null;
        private byte[] pskIdentity = null;
        private byte[] srpIdentity = null;
        private byte[] encodedServerExtensions = null;
        private boolean extendedMasterSecret = false;

        public SessionParameters build() {
            this.validate(this.cipherSuite >= 0, "cipherSuite");
            this.validate(this.compressionAlgorithm >= 0, "compressionAlgorithm");
            this.validate(this.masterSecret != null, "masterSecret");
            return new SessionParameters(this.cipherSuite, this.compressionAlgorithm, this.localCertificate, this.masterSecret, this.negotiatedVersion, this.peerCertificate, this.pskIdentity, this.srpIdentity, this.encodedServerExtensions, this.extendedMasterSecret);
        }

        public Builder setCipherSuite(int n) {
            this.cipherSuite = n;
            return this;
        }

        public Builder setCompressionAlgorithm(short s) {
            this.compressionAlgorithm = s;
            return this;
        }

        public Builder setExtendedMasterSecret(boolean bl) {
            this.extendedMasterSecret = bl;
            return this;
        }

        public Builder setLocalCertificate(Certificate certificate) {
            this.localCertificate = certificate;
            return this;
        }

        public Builder setMasterSecret(TlsSecret tlsSecret) {
            this.masterSecret = tlsSecret;
            return this;
        }

        public Builder setNegotiatedVersion(ProtocolVersion protocolVersion) {
            this.negotiatedVersion = protocolVersion;
            return this;
        }

        public Builder setPeerCertificate(Certificate certificate) {
            this.peerCertificate = certificate;
            return this;
        }

        public Builder setPSKIdentity(byte[] byArray) {
            this.pskIdentity = byArray;
            return this;
        }

        public Builder setSRPIdentity(byte[] byArray) {
            this.srpIdentity = byArray;
            return this;
        }

        public Builder setServerExtensions(Hashtable hashtable) throws IOException {
            if (hashtable == null || hashtable.isEmpty()) {
                this.encodedServerExtensions = null;
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                TlsProtocol.writeExtensions(byteArrayOutputStream, hashtable);
                this.encodedServerExtensions = byteArrayOutputStream.toByteArray();
            }
            return this;
        }

        private void validate(boolean bl, String string) {
            if (!bl) {
                throw new IllegalStateException("Required session parameter '" + string + "' not configured");
            }
        }
    }
}

